#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <string.h>


#define AUTOMOBIL 0
#define AUTOBUS 1
#define KAMION 2
#define VREME_DOLASKA 5
#define VREME_PRELASKA 4

pthread_mutex_t mu;
pthread_cond_t cond;

int broj_vozila = 7;
int zauzetost_nadvoznjaka[2]={0,0}; //smerovi koji su zauzeti
int broj_automobila_na_nadv = 0;
int broj_autobusa_na_nadv = 0;
int broj_kamiona_na_nadv = 0;
int vozila_koja_cekaju[2]={0,0}; //vozila koja cekaju po smeru

int odrediTip(int tip_vozila){
    
}

void* nadvoznjak(void* i){
    long idx = (long)i;
    int smer = rand()%2; //smer moze biti 0 ili 1 vozila koje je doslo
    int tip_vozila = rand()%3;
    char tip[10];
    strcpy(tip, tip_vozila==AUTOMOBIL?"automobil":tip_vozila==AUTOBUS?"autobus":"kamion");

    int vreme_dolaska = rand()%VREME_DOLASKA;
    sleep(vreme_dolaska);

    printf("Vozilo %ld - %s zeli da predje nadvoznjak u smeru %d.\n", idx, tip, smer);

    pthread_mutex_lock(&mu);

    int suprotan_smer = smer==0 ? 1 : 0;
    
    // vozila_koja_cekaju[smer]++;

    if(tip_vozila==AUTOMOBIL){
        //ne moze da prodje ako ima kamiona
        while(zauzetost_nadvoznjaka[suprotan_smer]>0 || broj_kamiona_na_nadv!=0 
        // || vozila_koja_cekaju[suprotan_smer]>0
        ){
            printf("Vozilo %ld - %s uvidja da ima %d kamiona i %d autobusa i %d automobila.\n", idx, tip, broj_kamiona_na_nadv, broj_autobusa_na_nadv, broj_automobila_na_nadv);
            printf("Postoji %d vozila u smeru %d - Vozilo %ld - %s ceka\n", zauzetost_nadvoznjaka[suprotan_smer], suprotan_smer,  idx, tip);
            pthread_cond_wait(&cond, &mu);
        }
    }

    else if(tip_vozila==AUTOBUS){
        //ne moze da prodje ako ima kamiona i autobusa
        while(zauzetost_nadvoznjaka[suprotan_smer]>0 || broj_kamiona_na_nadv!=0 || broj_autobusa_na_nadv!=0 
        // || vozila_koja_cekaju[suprotan_smer]>0
        ){
            printf("Vozilo %ld - %s uvidja da ima %d kamiona i %d autobusa i %d automobila.\n", idx, tip, broj_kamiona_na_nadv, broj_autobusa_na_nadv, broj_automobila_na_nadv);
            printf("Postoji %d vozila u smeru %d - Vozilo %ld - %s ceka\n", zauzetost_nadvoznjaka[suprotan_smer], suprotan_smer, idx, tip);
            pthread_cond_wait(&cond, &mu);
        }
    }

    else{
        //ne moze da prodje ako ima bilo kog vozila
         while(zauzetost_nadvoznjaka[suprotan_smer]>0 || broj_kamiona_na_nadv!=0 || broj_autobusa_na_nadv!=0 || broj_automobila_na_nadv!=0 
        //  || vozila_koja_cekaju[suprotan_smer]>0
         ){
            printf("Vozilo %ld - %s uvidja da ima %d kamiona i %d autobusa i %d automobila.\n", idx, tip, broj_kamiona_na_nadv, broj_autobusa_na_nadv, broj_automobila_na_nadv);
            printf("Postoji %d vozila u smeru %d koja se krecu - Vozilo %ld - %s ceka\n", zauzetost_nadvoznjaka[suprotan_smer], suprotan_smer, idx, tip);
            pthread_cond_wait(&cond, &mu);
        }
    }
    // vozila_koja_cekaju[smer]--;

    pthread_cond_broadcast(&cond);

    printf("Vozilo %ld - %s moze da pristupi nadvoznjaku.\n", idx, tip);

    if(tip_vozila==AUTOMOBIL){
        broj_automobila_na_nadv++;
    }
    else if(tip_vozila==AUTOBUS){
        broj_autobusa_na_nadv++;
    }
    else{
        broj_kamiona_na_nadv++;
    }
    
    printf("Vozilo %ld-%s - postoji %d vozila koja cekaju.\n", idx, tip, vozila_koja_cekaju[smer]);
    zauzetost_nadvoznjaka[smer]++; //broj vozila u datom smeru vozila
    printf("Vozilo %ld - %s prelazi nadvoznjak.\n", idx, tip);
    pthread_mutex_unlock(&mu);

    int vreme_prelaska = rand()%VREME_PRELASKA;
    sleep(vreme_prelaska); //da bismo imali realan prikaz prelaska 

    pthread_mutex_lock(&mu);

    printf("Vozilo %ld - %s je preslo nadvoznjak.\n", idx, tip);
    if(tip_vozila==AUTOMOBIL){
        broj_automobila_na_nadv--;
        printf("Na nadvoznjaku sad ima %d automobila.\n", broj_automobila_na_nadv);
    }
    else if(tip_vozila==AUTOBUS){
        broj_autobusa_na_nadv--;
        printf("Na nadvoznjaku sad ima %d autobusa.\n", broj_autobusa_na_nadv);
    }
    else{
        broj_kamiona_na_nadv--;
        printf("Na nadvoznjaku sad ima %d kamiona.\n", broj_kamiona_na_nadv);
    }

    zauzetost_nadvoznjaka[smer]--;

    printf("Vozilo %ld - %s je sislo sa nadvoznjaka.\n", idx, tip);
    pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mu);
}

int main(){
    pthread_t vozila[broj_vozila];

    pthread_mutex_init(&mu, NULL);
    pthread_cond_init(&cond, NULL);
    for(long i=0;i<broj_vozila;i++){
        pthread_create(&vozila[i], NULL, nadvoznjak, (void*)i);
    }

     for(long i=0;i<broj_vozila;i++){
        pthread_join(vozila[i], NULL);
    }

    return 0;
}